/*
 * Load and save certain state/Redux items into local storage (e.g. language settings)
 */
import settings from 'electron-settings';
import { DEFAULT_LANGUAGE_CODE } from './reducers/language';

export function loadPersistedState() {
    const language = settings.getSync('language', DEFAULT_LANGUAGE_CODE);

    return {
        language
    };
}

export function subscribePersistedStore(store) {
    store.subscribe(() => {
        settings.setSync('language', store.getState().language);
    });
}
